/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.VWLinkerPanel;
import filenet.vw.apps.linker.images.VWImageLoader;
import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWLoadingWindow;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.ImageIcon;

public class VWLinkerApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener {
    private VWLinkerPanel m_linkerPanel = null;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            if (!sessionInfo.verifyLogon(null)) {
                System.exit(1);
            }
            VWLinkerApplication pApp = new VWLinkerApplication();
            pApp.init(sessionInfo);
            VWHelp.init(pApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            this.setFormattedWindowTitle(VWResource.ApplicationTitle);
            ImageIcon icon = VWImageLoader.createImageIcon("linker_32.gif");
            if (icon != null && icon.getImage() != null) {
                this.setIconImage(icon.getImage());
            }
            if (!this.updatePosition("linker_location", "linker_size")) {
                Dimension dim = VWStringUtils.stringToDimension(VWResource.s_mainWindowDim);
                if (dim == null) {
                    dim = new Dimension(650, 400);
                }
                this.updatePosition(dim.width, dim.height);
            }
            VWLoadingWindow loadingWindow = new VWLoadingWindow((Frame)this, VWResource.ApplicationTitle);
            this.show();
            if (loadingWindow != null) {
                loadingWindow.start(this, 250);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            this.m_linkerPanel = new VWLinkerPanel();
            this.getContentPane().setLayout(new BorderLayout(4, 4));
            this.getContentPane().add((Component)this.m_linkerPanel, "Center");
            this.m_linkerPanel.init(this.m_sessionInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean destroy() {
        try {
            if (this.m_linkerPanel != null) {
                this.m_linkerPanel.destroy();
            }
            return super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }
}

